**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************
** This code is built of code from Nguyen (2022) Debt Covenant RBA RDP
 sysdir set PLUS ""
 global data ""
 global results ""
 
clear all
set more off
set maxvar 30000
set matsize 10000

//Load data for analysis - From Nguyen - not avaialble for sharing

use "${data}\covenants_analysis.dta", clear

g logcapex = log(-capitalexpenditurepurchaseppe915)

//Set up panel
xtset id year, delta(1)

//Global control vars
global controlvars "Lassets Lrevenue Lcash Lgearing Ldebt"
drop dloginvestment*
g dloginvestment=d.loginvestment
//Set up for Local Projections 
foreach x in loginvestment logstaffexpenses logcapex dloginvestment {
forv h = 0/4 {
gen `x'`h' = f`h'.`x'				
}
}

drop if nonmining==0 //remove mining
drop if gics_s==10
drop if gics_s== 40 // drop fin

//Define top 5 in revenue firms in the industry each year
bysort year gics_sector: egen rankrev = rank(revenueannual) 
g top5 = (rankrev<=5)
g top3 = (rankrev<=3)
bysort year gics_sector: g obs = _N
g top5_pc = (rankrev<=(obs/100*5))
xtset id year

g cura_rat = (curasset-curliab)/assets
drop if (cura_rat>10 & cura_rat!=.) | cura_rat<-10
drop if liabilities/assets>10 & liabilities/assets!=.
drop if (revenueannual/l.revenueannual>2 & revenueannual/l.revenueannual!=.) | revenueannual/l.revenueannual<=0
g lrevfy= log(revenueannual)
xtset id year

drop obs
bysort id: g obs = _N
drop if _N <10
xtset id year

g cr= 4.52 if year == 2002
replace cr = 4.75 if year == 2003 
replace cr = 5.06 if year == 2004 
replace cr = 5.33 if year == 2005 
replace cr = 5.54 if year == 2006 
replace cr = 6.14 if year == 2007 
replace cr = 6.82 if year == 2008 
replace cr = 4.77 if year == 2009 
replace cr = 3.68 if year == 2010 
replace cr = 4.66 if year == 2011 
replace cr = 4.34 if year == 2012 
replace cr = 3.13 if year == 2013 
replace cr = 2.53 if year == 2014 
replace cr = 2.36 if year == 2015 
replace cr = 1.96 if year == 2016 
replace cr = 1.52 if year == 2017 
replace cr = 1.50 if year == 2018 
replace cr = 1.48 if year == 2019 
replace cr = 0.66 if year == 2020 

egen ind_yr = group(gics_sector year)

g top_shock = BTCS_UA*l.top5_pc
g top_shock_cr = BTCS_UA*l.top5_pc*cr
g top_cr = l.top5_pc*cr



** Levels
//IRF - Both
eststo clear
forv h = 0/4 {
eststo: areg loginvestment`h' l.loginvestment BTCS_UA top_shock  l.BTCS_UA l.top_shock  l.i..top5_pc##l(0/1).c.(d.lrevfy)  ,  cluster(year) a(gics_sector)
}
esttab  using "${results}\lp_lead_morn_level_both.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

eststo clear

** leader
forv h = 0/4 {
eststo: areg loginvestment`h' l.loginvestment BTCS_UA  top_shock l.top_shock l.BTCS_UA  l.i..top5_pc##l(0/1).c.(d.lrevfy),  cluster(year) a(ind_yr)
*lincom c.BTCS_UA#1.l.top5_pc - c.BTCS_UA#0.l.top5_pc, level(90)
}
esttab  using "${results}\lp_lead_iy_morn_level_both.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

* both no control
eststo clear
forv h = 0/4 {
eststo: areg loginvestment`h' l.loginvestment BTCS_UA top_shock  l.BTCS_UA l.top_shock  l.i..top5_pc ,  cluster(year) a(gics_sector)
}
esttab  using "${results}\lp_lead_morn_level_both_nc.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
eststo clear


** leader no control
forv h = 0/4 {
eststo: areg loginvestment`h' l.loginvestment BTCS_UA  top_shock l.top_shock l.BTCS_UA  l.i..top5_pc,  cluster(year) a(ind_yr)
*lincom c.BTCS_UA#1.l.top5_pc - c.BTCS_UA#0.l.top5_pc, level(90)
}
esttab  using "${results}\lp_lead_iy_morn_level_both_nc.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps



** growth
eststo clear
forv h = 0/4 {
eststo: areg dloginvestment`h' l.dloginvestment BTCS_UA top_shock  l.BTCS_UA l.top_shock  l.i..top5_pc##l(0/1).c.(d.lrevfy)  ,  cluster(year) a(gics_sector)
}
esttab  using "${results}\lp_lead_morn_gr_both.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

eststo clear

** leader
forv h = 0/4 {
eststo: areg dloginvestment`h' l.dloginvestment BTCS_UA  top_shock l.top_shock l.BTCS_UA  l.i..top5_pc##l(0/1).c.(d.lrevfy),  cluster(year) a(ind_yr)
*lincom c.BTCS_UA#1.l.top5_pc - c.BTCS_UA#0.l.top5_pc, level(90)
}
esttab  using "${results}\lp_lead_iy_morn_gr_both.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

eststo clear
forv h = 0/4 {
eststo: areg dloginvestment`h' l.dloginvestment BTCS_UA top_shock  l.BTCS_UA l.top_shock  l.i..top5_pc ,  cluster(year) a(gics_sector)
}
esttab  using "${results}\lp_lead_morn_gr_both_nc.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

eststo clear

** leader
forv h = 0/4 {
eststo: areg dloginvestment`h' l.dloginvestment BTCS_UA  top_shock l.top_shock l.BTCS_UA  l.i..top5_pc,  cluster(year) a(ind_yr)
*lincom c.BTCS_UA#1.l.top5_pc - c.BTCS_UA#0.l.top5_pc, level(90)
}
esttab  using "${results}\lp_lead_iy_morn_gr_both_nc.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


